//////////////////////////////////////////////////////
//	File	:	"CWinGameState.h"
//
//	Author	:	Liam Russell
//
//	Purpose	:	This is the win game state for the game
//////////////////////////////////////////////////////

#include "CWinGameState.h"
#include "CSGD_DirectInput.h"
#include "CGame.h"
#include "CSGD_Direct3D.h"
#include "CSGD_TextureManager.h"
#include "CSGD_ObjectManager.h"
#include "CSGD_EventSystem.h"
#include "CCreditsState.h"
#include "CNoteManager.h"
#include "CBitmapFontManager.h"

//////////////////////////////////////////
// Function: "CWinGameState"
//
// Purpose:  Constructor
//////////////////////////////////////////
CWinGameState::CWinGameState()
{
	m_nImageID = 0;
}

//////////////////////////////////////////
// Function: "~CWinGameState"
//
// Purpose:  Destructor
//////////////////////////////////////////
CWinGameState::~CWinGameState()
{

}

//////////////////////////////////////////
// Function: "Enter"
//
// Purpose:  Initializes the class
//////////////////////////////////////////
void CWinGameState::Enter(void)
{
	m_pTM = CSGD_TextureManager::GetInstance();
	m_pDI = CSGD_DirectInput::GetInstance();

	m_pBM = CBitmapFontManager::GetInstance();
	m_pFont = m_pBM->CreateTemplateInstance(m_pBM->LoadTemplate("Resources/menuFont.xml"));
	m_pFont.LoadKerning("Resources/YesterdayFONT.dat");
	m_pFont.SetScaleX(0.9f);
	m_pFont.SetScaleY(0.9f);

	if(CNoteManager::GetInstance()->DidWin())
		m_nImageID = m_pTM->LoadTexture("Resources/Win_Screen.png");
	else
		m_nImageID = m_pTM->LoadTexture("Resources/Lose_Screen.png");

	m_rImageArea.left = 0;	m_rImageArea.top = 0;	m_rImageArea.right = 749;	m_rImageArea.bottom = 599;	
}
//////////////////////////////////////////
// Function: "Exit"
//
// Purpose:  Cleans up the class 
//////////////////////////////////////////
void CWinGameState::Exit(void)
{
}
//////////////////////////////////////////
// Function: "Input"
// Purpose:  Handles input for the options
//			 based on time
//////////////////////////////////////////
bool CWinGameState::Input(float fElapsedTime)
{
	
	if(m_pDI->GetBufferedKey(DIK_RETURN))
	{
		CGame::GetInstance()->RemoveAllStates();
		CGame::GetInstance()->AddState(CCreditsState::GetInstance());
	}

	return true;
}

//////////////////////////////////////////
// Function: "Update"
//
// Purpose:  Updates the class based on time
//////////////////////////////////////////
void CWinGameState::Update(float fElapsedTime)
{

}
//////////////////////////////////////////
// Function: "Render"
//
// Purpose:  Draws a black backround if no movie is playing
//////////////////////////////////////////
void CWinGameState::Render(void)
{

	m_pTM->DrawTexture(m_nImageID, 0.0f, 0.0f, 0.0f, .8f, .75f);

	char buffer[64];
	sprintf_s(buffer, "Press Enter to continue.");
	m_pFont.DrawString(buffer, 240, 500, D3DXCOLOR(1.0f, 0.0f, 0.0f, 1.0f));
}
